Imports System.Reflection
Imports System.IO
Imports DotNetAssembly = System.Reflection.Assembly

Module Module1
    ' Voici les mthodes permettant de vrifier tous les types.
    Private Sub ListAllTypes(ByVal a As DotNetAssembly)

        Console.WriteLine("Lister tous les types dans :")
        Console.WriteLine(a.FullName)
        Dim types() As Type = a.GetTypes()
        Dim t As Type
        For Each t In types
            Console.WriteLine("Type : {0}", t)
        Next
    End Sub

    Private Sub ListAllMembers(ByVal a As DotNetAssembly)
        Dim miniVan As Type = a.GetType("CarLibrary.MiniVan")
        Console.WriteLine("Lister tous les membres de {0}", _
            miniVan.FullName)

        Dim mi() As MemberInfo = miniVan.GetMembers()
        Dim m As MemberInfo
        For Each m In mi
            Console.WriteLine("Type {0} : {1} ", _
                    m.MemberType.ToString(), m)
        Next
    End Sub

    Private Sub GetParams(ByVal a As DotNetAssembly)
        Dim miniVan As Type = a.GetType("CarLibrary.MiniVan")
        Dim mi As MethodInfo = miniVan.GetMethod("TurnOnRadio")
        Console.WriteLine("Voici les paramtres de {0}", mi.Name)

        ' Afficher le nombre de paramtres.
        Dim myParams() As ParameterInfo = mi.GetParameters()
        Console.WriteLine("La mthode a {0} paramtres", myParams.Length)

        ' Afficher des infos sur les paramtres.
        Dim pi As ParameterInfo
        For Each pi In myParams
            Console.WriteLine("Nom du paramtre : {0}", pi.Name)
            Console.WriteLine("Position dans la mthode : {0}", pi.Position)
            Console.WriteLine("Type du paramtre : {0}", pi.ParameterType)
        Next
    End Sub


    Sub Main()
        ' Utiliser la classe Assembly pour charger la bibliothque.
        Dim a As DotNetAssembly
        Try

            ' Vous pouvez utiliser une chane...
            'a = DotNetAssembly.Load("CarLibrary, Ver=1.0.581.32902, PublicKeyToken=null, Culture=""")

            ' ... ou une rfrence  un AssemblyName...
            Dim asmName As AssemblyName
            asmName = New AssemblyName()
                      asmName.Name = "CarLibrary"
            Dim v As Version = New Version("1.0.581.32902")
            asmName.Version = v
            ' ...pour charger un assembly!
            a = DotNetAssembly.Load(asmName)
        Catch e As FileNotFoundException
            Console.WriteLine(e.Message)
        End Try
        ' Afficher les rsultats.
        ListAllTypes(a)
        Console.WriteLine()
        ListAllMembers(a)
        Console.WriteLine()
        GetParams(a)
    End Sub

End Module
